/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.export.csv;

import cz.insophy.inplan.export.csv.CsvFormat;
import cz.insophy.inplan.export.csv.CsvFormatter;
import cz.insophy.inplan.export.csv.CsvTableWriter;
import java.io.IOException;
import org.apache.commons.csv.CSVPrinter;

public class CompatibilityCsvTableWriter
extends CsvTableWriter {
    private final CsvFormat format;

    public static CsvTableWriter createWriter(CSVPrinter writer, CsvFormatter formatter, CsvFormat format) throws IOException {
        return new CompatibilityCsvTableWriter(writer, formatter, format);
    }

    private CompatibilityCsvTableWriter(CSVPrinter writer, CsvFormatter formatter, CsvFormat format) {
        super(writer, formatter);
        this.format = format;
    }

    @Override
    public void newCell(String value) {
        if (value != null) {
            StringBuilder sb = new StringBuilder(value.length() + 7);
            if (this.format.isDoQuoting()) {
                sb.append('\"');
            }
            for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                if (c == this.format.getEscape() || c == this.format.getQuotechar()) {
                    sb.append(this.format.getEscape());
                }
                sb.append(c);
            }
            if (this.format.isDoQuoting()) {
                sb.append('\"');
            }
            super.newCell(sb.toString());
        } else if (this.format.isDoQuoting()) {
            super.newCell("\"\"");
        }
    }
}

